/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.repair.utils;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.ProblemNotRegisteredException;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.repair.utils.RVRetainRequestProcessor;
import java.beans.PropertyVetoException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XRVUtils {
    private static final String TRACE_MASKT = "XRVX065T";
    private static final String TRACE_MASKF = "XRVX065F";
    private static final String TRACE_MASKD = "XRVX065D";

    public static void closeProblemAndServiceAction(Map userData) throws HException {
        Problem p = (Problem)userData.get("PROBLEM");
        String descrip = (String)userData.get("FIX_DESCRIPTION");
        Integer tm = (Integer)userData.get("TOOL_MODE");
        int toolMode = 0;
        if (tm != null) {
            toolMode = tm;
        }
        Trace.trace(TRACE_MASKT, "-> XRVUtils.closeProblemAndServiceAction, Problem[" + p + "], ServiceAction[" + p.getServiceAction() + "], Description[" + descrip + "], ToolMode[" + toolMode + "]");
        if (p != null) {
            try {
                if (p instanceof CommonProblem) {
                    CommonProblem commonProblem = (CommonProblem)p;
                    boolean detected = (toolMode & 1) == 0;
                    boolean managed = (toolMode & 2) == 0;
                    Trace.trace(TRACE_MASKD, "XRVUtils.closeProblemAndServiceAction - handling XSH_REPAIR_ENDED for managed problems");
                    commonProblem.serviceHistoryEvent(new HistoryEntry(9));
                    List exchangedFrus = (List)userData.get("EXCHANGED_FRUS");
                    if (exchangedFrus != null) {
                        Iterator partIt = exchangedFrus.iterator();
                        while (partIt.hasNext()) {
                            ServiceableElement.PersistentDataImpl fruPDI = (ServiceableElement.PersistentDataImpl)partIt.next();
                            Map fruProps = fruPDI.properties;
                            commonProblem.addReplacedPart(new CommonPaFru("", (String)fruProps.get("LOCATION"), (String)fruProps.get("PART_NUM"), (String)fruProps.get("SERIAL_NUM"), "", (String)fruProps.get("EC_LEVEL")));
                        }
                    }
                    commonProblem.addFixDescription(descrip == null ? "" : descrip);
                }
                try {
                    ProblemManager.getProblemManager().close(p);
                    ProblemManager.getProblemManager().changed(p);
                    RVRetainRequestProcessor.initiateRVRequest(userData);
                }
                catch (ProblemNotRegisteredException e) {}
            }
            catch (PropertyVetoException e) {
                Trace.trace(TRACE_MASKT, "<-! XRVUtils.closeProblemAndServiceAction; PropertyVetoException closing Problem[" + e + "]");
                throw new HException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- XRVUtils.closeProblemAndServiceAction");
    }
}

